#!/usr/bin/env python
# coding: Shift_JIS

# ##############################

# t@C: split_funcs.py
# @\: ExcelŃ[UI\[Xt@C̏E֐ƂɕD
#	split_funcs.pyȍ~̃W[͕ꂽe֐ɂ鏈EΏۂɎsD
# ֐: make_dir, allocateID, split_funcs
# Җ: R{Cяh

# ##############################

import re
import os
import shutil
import sys

# ##############################

# ֐: make_dir
# @\: w肳ꂽ̂̃fBNg쐬D
# 
#   dir_path: 쐬fBNg̖

# ##############################

def make_dir(dir_path):
    if os.path.isdir(dir_path)==True:
        shutil.rmtree(dir_path)
    os.mkdir(dir_path)


# argument : idlist,sequence̊es
# return   : ID,ST1犄Uꂽidlist,sequence̊es

# ##############################

# ֐: allocateID
# @\: ID, ST̔ԍ蓖Ē
# 
#   ld_lines: ͊֐̍s
#   sq_lines: ȊO̍s

# ##############################

def allocateID(id_lines,sq_lines):

    idcnt = 1
    for i,id_line in enumerate(id_lines):
        temp = id_line.split("\t",1)
        id = temp[0]
        rest = temp[1]
        regep = id+"(\\t|\\n|$)"

        for j,seq in enumerate(sq_lines):
            temp = re.sub(regep,"ID"+str(idcnt),seq)
            temp = temp.split("ID")
            if len(temp) == 2:
                temp2 = temp[1].split("ST")
                temp[1] = temp2[0]
                for t2 in temp2[1:]:
                    if "ST"+t2 not in temp:
                        temp.append("ST"+t2)
            result = ""

            for t in temp:
                t = t.replace("\t","")
                if t == '': continue
                if "ST" in t: result += t + "\t"
                else: result += "ID"+t +"\t"
            result = result[:-1].replace("\n","")
            sq_lines[j] = result
            id_lines[j] = re.sub(regep,"ID"+str(idcnt)+"\t",id_lines[j])

        idcnt += 1

    stcnt = 1
    for i, seq in enumerate(sq_lines):
        row = seq.split("\t")
        line = ""
        for r in row:
            if "ID" in r:
                line += r+"\t"
                continue
            line += "ST" + str(stcnt) + "\t"
            stcnt += 1
        sq_lines[i] = line

    return (id_lines,sq_lines)

# ##############################

# ֐: split_funcs
# @\: ΏCt@C̏C܂Ƃ߂t@C֐ƂɕD
# 
#   directory: ͑Ώۂ̃t@CɊւ񂪂܂Ƃ߂ꂽfBNg

# ##############################

def split_funcs(directory):

    print("\n===============")
    print("= split_funcs =")
    print("directory: ",directory)
    print("===============\n")

    # ############################

    # ֐: split_funcs
    # @\F ΏCt@C̏C܂Ƃ߂t@C֐Ƃɕ


    # INPUT F idlist2.tsv, stlist.tsv, sequence6.tsv
    # OUTPUT: idlist2-1.tsv, stlist2.tsv, sequence6-1.tsv
    #         idlist2-2.tsv, sequence6-2.tsv
    # RETURN: func_dic [dict^]

    # INPUT̓͌: temp/
    # OUTPUT̏o͐: temp/FUNCTION/ (FUNCTION͔Cӂ̊֐)

    # idlist2.tsv   : ʂԍ(ID***)蓖Ăꂽ̈ꗗ
    # stlist.tsv    : ʂԍiST***)蓖Ăꂽ̈ꗗ
    # sequence6.tsv : iID)ƁC̐\ɓIDCST̈ꗗ

    # idlist2-1.tsv   : idlist2.tsv֐ʂɕt@C
    # stlist2.tsv     : stlist.tsv֐ʂɕt@C
    # sequence6-1.tsv : sequence6.tsv֐ʂɕt@C

    # idlist2-2.tsv   : idlist2-1.tsvID1Ċ蓖Ăt@C
    # sequence6-2.tsv : sequence6-1.tsvID,STĊ蓖Ăt@C

    # func_dic : idlist2.tsvɋLڂĂ֐
    #            ォ珇ԂɊi[ꂽIuWFNg
    #            {ʂԍ:֐}

    # ############################

    # INPUTt@C̓ǂݍ
    out_directory = "temp/" + directory + "/"

    rfile = out_directory + "idlist2.tsv"
    fi = open(rfile)
    id_lines = fi.readlines()
    fi.close()

    rfile = out_directory + "stlist.tsv"
    fi = open(rfile)
    st_lines = fi.readlines()
    fi.close()

    rfile = out_directory + "sequence6.tsv"
    fi = open(rfile,"r")
    sq_lines = fi.read()[:-1].split("\n")
    fi.close()


    # ֐̃fBNg쐬C
    # idlist2.tsv֐ƂɕăfBNgɏo͂
    funcids = []
    funcnames = []

    for i,id_line in enumerate(id_lines):
        temp = id_line.split("\t")
        id = temp[0]
        code = temp[1]
        nest = int(temp[2])
        if nest == 0:
            funcids.append(id)
            funcnames.append(code)
            dir_path = out_directory + code + "/"
            make_dir(dir_path)
            fo_id = open(dir_path +"idlist2_1.tsv",'w')

        print (id_line,file=fo_id,end="")

        if i != len(id_lines)-1:
            next_nest = int(id_lines[i+1].split("\t")[2])
            if next_nest == 0:
                fo_id.close()
    fo_id.close()


    # sequence6.tsv, stlist.tsv
    # ֐ƂɕăfBNgɏo͂
    funccnt = 1
    for i,sq_line in enumerate(sq_lines):
        temp = sq_line.split("\t",1)
        target_id = temp[0]
        rest_ids = temp[1]

        if target_id == funcids[funccnt-1]:
            funcname = funcnames[funccnt-1]
            dir_path = out_directory + funcname + "/"
            fo_sq = open(dir_path +"sequence6_1.tsv",'w')
            fo_st = open(dir_path +"stlist2.tsv",'w')

        print (sq_line + "\n" ,file=fo_sq,end="")
        temp = rest_ids.split("\t")
        for t in temp:
            if "ST" in t:
                stnum = int(t[2:])
                st_line = st_lines[stnum-1]
                print (st_line,file=fo_st,end="")

        if funccnt != len(funcids):
            next_target_id = sq_lines[i+1].split("\t")[0]
            if next_target_id == funcids[funccnt]:
                funccnt += 1
                fo_sq.close()
                fo_st.close()

    fo_sq.close()
    fo_st.close()


    # ID, ST̔ԍ蓖Ē
    for funcname in funcnames:
        dir_path = out_directory + funcname + "/"

        rfile = dir_path + "idlist2_1.tsv"
        fi = open(rfile)
        id_lines = fi.readlines()
        fi.close()

        rfile = dir_path + "sequence6_1.tsv"
        fi = open(rfile,"r")
        sq_lines = fi.read()[:-1].split("\n")
        fi.close()

        fo_id = open(dir_path + "idlist2_2.tsv",'w')
        fo_sq = open(dir_path + "sequence6_2.tsv",'w')

        newid_lines, newsq_lines =\
            allocateID(id_lines,sq_lines)

        for newid_line in newid_lines:
            print (newid_line,file=fo_id,end="")

        for newsq_line in newsq_lines:
            print (newsq_line + "\n" ,file=fo_sq,end="")

        fo_id.close()
        fo_sq.close()

    # senni.py(split_funcs.py̌Ăяo)
    # oʂԍF֐p̎^Ԃ
    func_dic = {}
    for i,funcname in enumerate(funcnames):
        func_dic.update({i:funcname})
    return func_dic

if __name__ == '__main__':
    split_funcs(sys.argv[1],sys.argv[2])
