#!/usr/bin/env python
# coding: Shift_JIS

# ##############################

# t@C: exception_handling.py
# @\: [UIԕϐ܂ސ\̃lXg̐[Cԕϐ̎肤l̎ނ̒l傫ꍇCxEG[𐶐D
# ֐: ReportException, getCondVal, getCondDepth, exception_handling
# Җ: R{Cяh

# ##############################

import os
import re
import sys

DEPTH_MAX = 5
VALS_MAXNUM = 20

# ##############################

# ֐: ReportException
# @\: G[eTSV_info/stm_report_message.txtɏoD
# 
#   error_message: G[e

# ##############################

def ReportException(report_message):
    reportfile= "TSV_info/stm_report_message.txt"

    if os.path.exists("TSV_info/stm_report_message.txt"):
        message = open(reportfile,"a")
    else:
        message = open(reportfile,"w")
    message.write(report_message)
    message.close()

# ##############################

# ֐: getCondVal
# @\: ŏԕϐrĂl𒲂ׂD
# 
#   instring: ͒̍s
#   param: ԕϐ

# ##############################

# INPUT: id_lines̊esCԕϐ
# OUTPUT: ŏԕϐrĂl
def getCondVal(instring,param):
    if re.match(".*if\("+ param +"\s*==",instring):
        row = instring.split("==")
        val = row[1].rsplit(")")[0]
        if re.match("\(.+\)",val):
            val = val[1:-1]
        else:
            val = val
    else:
        val = ""
    return val

# ##############################

# ֐: getCondVal
# @\: ԕϐ܂ޏ̃lXg̐[𒲂ׂD
# 
#   instring: ͒̍s
#   param: ԕϐ

# ##############################

# INPUT: id_lines̊esCԕϐ
# OUTPUT: ԕϐ܂ޏ̃lXg̐[
#         (ԕϐ݂Ȃꍇ0Ԃj
def getCondDepth(instring,param):
    if re.match(".*if\("+param, instring):
        nest_depth = instring.rsplit("\t")[-1].replace("\n","")
    else:
        nest_depth = 0

    return int(nest_depth)

# ##############################

# ֐: exception_handling
# @\: id_list̊esQƂCz肵Ȃp^[ɑ΂ČxEG[o͂D
# 
#   param: ϐ
#   directory: ͑Ώۂ̊֐Ɋւ񂪂܂Ƃ߂ꂽfBNg

# ##############################

def exception_handling(param,directory):


    print("\n===============")
    print("= exception_handling =")
    print("param: ", param)
    print("directory: ",directory)
    print("===============\n")

    # ############################

    # ֐: exception_handling
    # @\F 1) id_list̊esQƂCz肵Ȃp^[ɑ΂ČxEG[o͂

    # INPUT F idlist2-5.tsv
    # OUTPUT: stm_report_message.tsv

    # INPUT̓͌ : temp/FUNCTION/ (FUNCTION͔Cӂ̊֐)
    # OUTPUT̏o͐: TSV_info/

    # idlist2-5.tsv   : e֐ɂ̈ꗗ

    # stm_report_message.tsv : e֐ɂxEG[܂Ƃ߂t@C
    #                          es̃tH[}bg "WARNING:[(֐)] (xe)\n" C
    #                                      邢  "ERROR:[(֐)] (G[e)\n"
    # ############################

    out_directory = "temp/" + directory + "/"

    rfile = out_directory + "idlist2_5.tsv"
    fi = open(rfile)
    lines = fi.readlines()
    fi.close()

    funcname = ""
    allMJKflg = True
    compare_operators = ["<",">","&&","||","!="]

    for i,line in enumerate(lines):
        depth = line.rsplit("\t")[-1].replace("\n","")
        code = line.split("\t")[1]
        nest = int(line.split("\t")[2])

        if int(depth) == 0:
            tmp = line.split("\t")[0]
            funcname = line.split("\t")[1]
            depth = 0
            vals = []
            val_cands = []
            overdepth_flg = False
            overvalnum_flg = False
            unknownope_flg = False
            allMJKflg = True
            jotaisenni = False


        if("if(" in code):
            cond = code.split("(",1)[1].rsplit(")",1)[0]
            if "==" in cond:
                cond_l = cond.split("==")[0].replace(" ","")
                cond_r = cond.split("==")[1].replace(" ","")
                if param == cond_l or param == cond_r:
                    print(cond_l,cond_r)
                    jotaisenni = True
            else:
                cond = cond.replace(" ","")
                if param == cond:
                    jotaisenni = True

        if("if(" in code and param in code):
            cond = code.split("(",1)[1].rsplit(")",1)[0]
            val_cands.append(cond.replace(" ","").split("==")[0])
            for cope in compare_operators:
                if cope in cond:
                   print("ERROR: A comparison operator that is not [==] is used.\n[" + funcname + "]")
                   ReportException("ERROR:[" + funcname + "] [==]ȊO̔rZqgĂ܂B\n")
                   return False
                   unknownope_flg = True


        cond_depth = getCondDepth(line,param)
        nest_outside = cond_depth - 1
        if nest_outside > DEPTH_MAX and overdepth_flg == False:
            print("ERROR: The depth of the nest outside the control syntax containing the state variable exceeds the specified number.\n[" + funcname + "]")
            ReportException("ERROR:[" + funcname + "] ԕϐ܂ސ\̊OɂlXg̐[K̐𒴂Ă܂B\n")
            return False
            overdepth_flg = True


        val = getCondVal(line,param)
        if val != "" and not(val in vals):
            vals.append(val)

        if len(vals) >= VALS_MAXNUM and overvalnum_flg == False:
            print("ERROR: The number of constant values taken by the state variable exceeds the limit.\n[" + funcname + "]")
            ReportException("ERROR:[" + funcname + "] ԕϐ̎肤萔l̎ނK̐𒴂Ă܂B\n")
            return False
            overvalnum_flg = True



        if nest == 1:
            if "%%%MJK%%%" not in line:
                allMJKflg = False

        if len(lines)-1 != i:
            if lines[i+1][-1] == "0" and allMJKflg == True:
               print("WARNING: Event does not exist.\n[" + funcname + "]")
               ReportException("WARNING:[" + funcname + "] Cxg݂܂B\n")

        if len(lines)-1 == i and allMJKflg == True:
               print("WARNING: Event does not exist.\n[" + funcname + "]")
               ReportException("WARNING:[" + funcname + "] Cxg݂܂B\n")

        if len(lines)-1 == i and jotaisenni == False:
               print("WARNING: State transition does not exist.\n[" + funcname + "]")
               ReportException("WARNING:[" + funcname + "] ԕϐ܂ޏ݂܂B\n")

        if len(lines)-1 == i and (param not in val_cands or len(val_cands)==0):
               print("WARNING: State variable does not exist.\n[" + funcname + "]")
               ReportException("WARNING:[" + funcname + "] ԕϐ݂܂B\n")

if __name__ == '__main__' :
    exception_handling(sys.argv[1],sys.argv[2])
