#!/usr/bin/env python
# -*- coding: Shift_JIS -*-

# ##############################

# t@C: analyze.py
# @\: \́C\쐬JnD
#	programs/analyze_programspythonXNvgĂяoD
# ֐: ReportException, CheckSyntax, MovePath, Preprocess, RemoveBlankLines,
#	CReform, PreIf, PreSw, Marking, Mujoken, Indent, GlobalDelete, ReplaceFilename
#	Postprocess
# Җ: R{Cяh

# ##############################

# convert python3 from kaiseki.sh

import os
import sys
import re
import shutil
import argparse
import codecs
import subprocess
import datetime

# O python \[XQ
import c_reform
import preif
import presw
import marking
import mujoken
import indent
import globaldelete
import pragma
import jokenshori
import table
import jotaivar
import rule_jotaivar

## for self configuration gcc(added 2018/01/23)
fi = open('lists/compile.txt', 'r')
comlines = fi.read()
fi.close()
comlines = comlines.replace('\r\n', ' ')
comlines = comlines.replace('\r', ' ')
comlines = comlines.replace('\n', ' ')
while '  ' in comlines: comlines = comlines.replace('  ', ' ')
comlines_str = comlines
comlines = comlines.split(' ')
GCC_PATH = comlines[0]
comlines = comlines[1:]
## end


# GCC_PATH = "gcc"

# ##############################

# ֐: ReportException
# @\: G[bZ[Wtemp/error_messageɏށD
# 
#   error_message: G[bZ[W

# ##############################

def ReportException(error_message):
    error = open("temp/error_message","w")
    error.write(error_message)
    error.close()

# ##############################

# ֐: CheckSyntax
# @\: ͑Ώۂct@CRpC\ł邩mFD
# 
#   filename: ͑Ώۂct@C

# ##############################

def CheckSyntax(filename):
    ferror = open('./log/compile_error.txt', 'a')
    # before begin
    gccSyntaxCheckCmd = ([GCC_PATH, "-fsyntax-only", "-w", "-P", filename])
    #before end
    #after begin
    gccSyntaxCheckCmd = ([GCC_PATH]+comlines+[filename])
    #after end
    p = subprocess.Popen(gccSyntaxCheckCmd, stdout=subprocess.PIPE,stderr=subprocess.PIPE)
    _,err = p.communicate()
    gccErr = err.decode("utf8","ignore")
    gccErr = gccErr.split("\n")
    newgccErr = []
    for ge in gccErr:
        if "error: unknown type name" in ge or "sȌ^" in ge or \
           "undeclared (first use in this function)" in ge or "錾Ă܂" in ge or \
           "error: stray" in ge or "vOɈE" in ge or \
           "error: invalid suffix" in ge or "萔ɖȐڔ" in ge or \
           "expected declaration specifiers" in ge or \
           "invalid digit" in ge or \
           " before numeric constant" in ge or \
           " undeclared here (not in a function)" in ge or \
           " in something not a structure or union" in ge or "\̂܂͋p̂ł͂Ȃ̃o" in ge:
             pass
        else:
            newgccErr.append(ge)
    newgccErr = "".join(newgccErr)
    for ge in gccErr:
        ge = ge.replace("___.c", ".c")
        print(ge, file=ferror)
    ferror.close()
    return newgccErr

# ##############################

# ֐: MovePath
# @\: RExSTM̃[gfBNgɈړD
# 
#   Ȃ

# ##############################

def MovePath():
    current_path = os.path.abspath(sys.argv[0])
    basename = os.path.basename(current_path)
    current_path = current_path.replace(basename,"")
    os.chdir(current_path)
    os.chdir('../..')

# ##############################

# ֐: Preprocess
# @\: ͑Ώۂct@C̐`sD
# 
#   filename: ͑Ώۂct@C

# ##############################

def Preprocess(filename):
    whndl = open("temp/temp_before.c","w")

    for line in open(filename,"r") :
        convline = line
        # Cfg̍폜
        convline = re.sub(r'^[ \t]*', '', convline)
        # {}Vsɂ
        convline = re.sub(r'\{','\n{\n', convline)
        convline = re.sub(r'\}','\n}\n', convline)
        ## 1s1߂݂̂
        # convline = convline.replace(';',';\n')
        # '('')'̂ꂼ̑Ő󔒕(Xy[Xƃ^u)폜
        ## python Ȃ strip() ̂ق
        convline = re.sub(r'[ \t]*\([ \t]*', '(', convline)
        convline = re.sub(r'[ \t]*\)[ \t]*', ')', convline)
        # ]ȉs폜
        convline = re.sub(r'\{[ \n\t]*\}', '{\n}\n', convline)
        convline = re.sub(r'}[ \t]*;', '\n}\n;\n', convline)
        convline = re.sub(r'[\n][\n]+', '\n', convline)
        # 
        if( len(convline) > 0 and convline != "\n" ) :
            whndl.write(convline)
    whndl.close()

# ##############################

# ֐: RemoveBlankLines
# @\: ͑Ώۂct@CsD
# 
#   Ȃ

# ##############################

def RemoveBlankLines():
    shutil.copyfile("temp/temp_before.c", "temp/temp1")
    whndl = open("temp/temp_before.c","w")
    for line in open("temp/temp1","r") :
        if( len(line) > 0 and line != "\n" ) :
            # 
            whndl.write(line)
    whndl.close()
    shutil.copyfile("temp/temp_before.c", "temp/temp1")
    shutil.copyfile("temp/temp_before.c", "temp/temp2")

# ##############################

# ֐: CReform
# @\: c_reformĂяoD
# 
#   Ȃ

# ##############################

def CReform():
    c_reform.c_reform("temp/temp1", "temp/temp2")
    shutil.copyfile("temp/temp2", "temp/temp1")
    shutil.copyfile("temp/temp2", "temp/c_reform")

# ##############################

# ֐: PreIf
# @\: preifĂяoD
# 
#   Ȃ

# ##############################

def PreIf():
    preif.preif("temp/temp1", "temp/temp2")
    shutil.copyfile("temp/temp2", "temp/temp1")
    shutil.copyfile("temp/temp2", "temp/preif")

# ##############################

# ֐: PreSw
# @\: preswĂяoD
# 
#   Ȃ

# ##############################

def PreSw():
    caseCheck = presw.presw("temp/temp1", "temp/temp2")
    if caseCheck == False:
        print("ERROR: The target has switch statements without internal case statements.\nTarget: [" + targetFiles[i] + "]")
        ReportException("ERROR: casêȂswitch݂܂B\nΏۃt@C: [" + targetFiles[i] + "]")
        shutil.move("temp/error_message", temp_dirname)
        return False

    shutil.copyfile("temp/temp2", "temp/temp1")
    shutil.copyfile("temp/temp2", "temp/presw")
    return True

# ##############################

# ֐: Marking
# @\: markingĂяoD
# 
#   Ȃ

# ##############################

def Marking():
    marking.marking("temp/temp1", "temp/temp2")
    shutil.copyfile("temp/temp2", "temp/temp1")
    shutil.copyfile("temp/temp2", "temp/marking")

# ##############################

# ֐: Mujoken
# @\: mujokenĂяoD
# 
#   Ȃ

# ##############################

def Mujoken():
    nestMaxDepth = mujoken.mujoken("temp/temp1", "temp/temp2")
    if nestMaxDepth > 6:
        print( "WARNING: Nesting depth greater than 5.\nTarget: [" + targetFiles[i] +"]")
        ReportException( "WARNING: [5傫lXg\݂܂B\nΏۃt@C: [" + targetFiles[i] + "]")
    shutil.copyfile("temp/temp2", "temp/temp1")
    shutil.copyfile("temp/temp2", "temp/mujoken")

# ##############################

# ֐: Indent
# @\: indentĂяoD
# 
#   Ȃ

# ##############################

def Indent():
    indent.indent("temp/temp1", "temp/temp2")
    shutil.copyfile("temp/temp2", "temp/temp1")
    shutil.copyfile("temp/temp2", "temp/indent")

# ##############################

# ֐: GlobalDelete
# @\: globaldeleteĂяoD
# 
#   Ȃ

# ##############################

def GlobalDelete():
    globaldelete.globaldelete("temp/temp1", "temp/temp2")
    shutil.copyfile("temp/temp2", "temp/temp1")
    shutil.copyfile("temp/temp2", "temp/globaldelete")

# ##############################

# ֐: ReplaceFilename
# @\: t@C
# 
#   filename: ͑Ώۂct@C

# ##############################

def ReplaceFilename(filename):
    tsvFileName = filename.replace(".c", ".tsv")
    tsvFileName = tsvFileName.replace(temp_dirname, "")
    return tsvFileName

# ##############################

# ֐: Postprocess
# @\: \\tsvt@Cɑ΂ĉš㏈sD
# 
#   tsvFileName: \\tsvt@C
#   temp_dirname: tempt@C܂Ƃ߂fBNg

# ##############################

def Postprocess(tsvFileName,temp_dirname):
    whndl = open("".join(["TSV_Result/", tsvFileName]), "wb")
    for line in open("temp/tableinfo/tableinfo3.tsv", "rb") :
        if( line[-2:] != b"\r\n" ) :
            line = line.replace(b"\n", b"\r\n")
        whndl.write(line)
    whndl.close()

    whndl = open("".join(["TSV_info/", tsvFileName.replace(".tsv",""), "_tableline.tsv"]), "wb")
    for line in open("temp/tableinfo/tableline.tsv","rb") :
        if( line[-2:] != b"\r\n" ) :
            line = line.replace(b"\n", b"\r\n")
        whndl.write(line)
    whndl.close()

    whndl = open("".join(["TSV_info/v_", tsvFileName]), "wb")
    for line in open("temp/jotaivarlist.tsv","rb") :
        if( line[-2:] != b"\r\n" ) :
            line = line.replace(b"\n", b"\r\n")
        whndl.write(line)
    whndl.close()

    shutil.move("temp/tableinfo", temp_dirname+"tableinfo")
    for tempfile in os.listdir("temp") :
        if os.path.isfile("temp/" + tempfile):
            shutil.move("temp/" + tempfile, temp_dirname + tempfile)

if __name__ == '__main__':

    # Select input C files
    print ("Read TargetPrograms")

    parser = argparse.ArgumentParser()
    parser.add_argument('-i','--no_include_flag',default = "y",type=str,help='Y/n ... You choice <Not_include> OR <Include> header files')
    parser.add_argument('-d','--debug_mode',default = "n",type=str,help='Y/n ... You make Log file /debug/analyze_YYYYMMDD.txt for stdout')
    parser.add_argument('-s','--stop_mode',\
                        default = "0",type=int,\
                        help='You can STOP after process \
                            [1:CheckSyntax][2:Preprocess][3:RemoveBlankLines][4:CReform]\
                            [5:PreIf][6:PreSw][7:Marking][8:Mujoken][9:Indent]\
                            [10:GlobalDelete][11:Pragma][12:ReplaceFilename][13:Jokenshori]\
                            [14:Table][15:Jotaivar][16:Rule_Jotaivar]')
    arg = parser.parse_args()

    if (arg.debug_mode.lower()=="y"):
        d = datetime.datetime.today()
        log_file = "debug/analyze_" + d.strftime('%Y%m%d%H%M%S') + ".txt"
        sys.stdout = open(log_file,"w")

    MovePath()

    if os.path.isdir("temp") == True:
        shutil.rmtree("temp")
    os.mkdir("temp")

    if os.path.isfile('./log/compile_error.txt'):
    	os.remove('./log/compile_error.txt')

    # Read all files
    targetFiles=[]
    temp_dirnames=[]

    for filename in os.listdir("TargetPrograms") :
        if filename[-2:] == ".c" :
            targetFiles.append("/".join(["TargetPrograms",filename]))

            temp_dirname = "temp/" + filename.replace(".c", "___o") + "/"
            temp_dirnames.append(temp_dirname)

            os.mkdir(temp_dirname)

    if len(targetFiles)==0:
        print("ERROR: C_source_file does NOT exist.")
        ReportException("ERROR: Ct@CTargetProgramstH_ɑ݂܂B")
        sys.exit(-1)

    ####################################
    #  (3) START
    ####################################


    #print ("Do you NOT include ALL header file?")
    #sys.stdout.write ("(Y/n) -> ")  # sȂo
    #print ("(Y/n)", end=" -> ")  # sȂo
    #all_header = input()

    all_header = arg.no_include_flag

    # Read all files
    targetNewFiles=[]
    if (all_header.lower() == "y") :
        print ("Delete all INCLUDE")
        for filename in targetFiles :

            if ( filename[-5:] == "___.c" ) :
                targetFiles.remove(filename)
                continue    # ut@CȂpX
            new_filename = filename.replace('.c', '___.c')
            if ( os.path.exists(new_filename) ) :
                os.remove(new_filename) # łɒut@CȂ
            whndl = open(new_filename,"wb")
            for line in open(filename,"rb") :
                if( re.match(b"[ \t]*#include", line) == None ) :
                    whndl.write(line)
            whndl.close()
            targetNewFiles.append(new_filename)
        print (targetNewFiles)


    # Read from no_included_files.txt
    elif (all_header.lower() == "n") :

        no_inc_files=[]

        #no_included_files.txt existent check
        print ("Read from no_included_files.txt")
        if ( os.path.exists("lists/no_included_files.txt") ) :
            print ("f1")
            for line in open("lists/no_included_files.txt","r") :
                no_inc_files.append(line.replace("\n",""))
        else :
            print("ERROR: no_included_files.txt does NOT exist.")
            ReportException("ERROR: no_included_files.txtliststH_ɑ݂܂B")
            sys.exit(-1)

        #std.txt existent check
        print ("Read from std.txt")
        if ( os.path.exists("lists/std.txt") ) :
            print ("f2")
            for line in open("lists/std.txt","r") :
                no_inc_files.append(line.replace("\n",""))
        else :
            print("ERROR: std.txt does NOT exist.")
            ReportException("ERROR: std.txtliststH_ɑ݂܂B")
            sys.exit(-1)

        print (" NOT valid header files\n", no_inc_files)

        for filename in targetFiles :
            if ( filename[-5:] == "___.c" ) :
                targetFiles.remove(filename)
                continue    # ut@CȂpX
            new_filename = filename.replace('.c', '___.c')
            if ( os.path.exists(new_filename) ) :
                os.remove(new_filename) # łɒut@CȂ

            targetNewFiles.append(new_filename)

            # [U炩ߑIwb_\[X珜O #
            # ̑̃wb_t@CTargetProgramsɒuĂȂ΃G[ #
            f = codecs.open(filename,"r", "shift_jis")
            source_lines = f.read()
            f.close()

            removed_headers=[]
            header_list = re.findall(r"[ \t]*#include[ \t][<\"].+[>\"]", source_lines)
            for header in header_list:
                for nif in no_inc_files:
                    if nif in header:
                        source_lines.replace(header,"")
                        removed_headers.append(header)

            header_list = [h for h in header_list if h not in removed_headers]
            header_list = [h.replace("#include ","") for h in header_list]
            header_list = [h.replace("\"","") for h in header_list]

            print ("valid header files\n",header_list)
            for header in header_list:
                if os.path.exists("TargetPrograms/" + header)==False:
                    filename = filename.replace("___.c", ".c")
                    print("ERROR: header_file does NOT exist "+header+"\n["+filename+"]")
                    ReportException("ERROR: wb_t@C"+header+"TargetProgramsɑ݂܂B\nΏۃt@C: ["+filename+"]")
                    sys.exit(-1)
            # ΏCt@CRpCł邩肷鏈
            # 炩Ct@C܂Ƃ߂鏈ɒu\ł
            # 170310

            # gccErr = CheckSyntax(filename)
            # if ("error:" in gccErr) or ("G[:" in gccErr):
            #     filename = filename.replace("___.c", ".c")
            #     print ("\n-----syntactic analysis-----\n" + gccErr + "\n-------------------------\n")
            #     print("ERROR: The target can not be analyzed by gcc.\n[" + filename + "]")
            #     ReportException("ERROR: gccō\͂ł܂B \nΏۃt@C: [" + filename + "]")
            #     sys.exit(-1)

            # gccExec = " ".join([GCC_PATH, "-E", filename, ">", new_filename])
            gccExec = " ".join([comlines_str, filename, ">", new_filename])
            print(gccExec)
            os.system(gccExec)
            newf = open(new_filename,"r")
            source_lines = newf.read()
            newf.close()

            pat = re.compile(r"#.+\"%s\"" %filename)
            source_lines = re.split(pat,source_lines)[-1]

            newf = open(new_filename,"w")
            newf.write(source_lines)
            newf.close()
        print (targetNewFiles)

    else :
        print("ERROR: Please input Y/n")
        ReportException("ERROR: Y  n ͂ĂB")
        sys.exit(-1)

    ####################################
    #  (4) START
    ####################################
    print ("Clear comments and expand MACROs")

    tempFiles=[]
    for i,filename in enumerate(targetNewFiles) :
        temp_dirname = temp_dirnames[i]
        new_filename = filename.replace("TargetPrograms/", temp_dirname)
        new_filename = new_filename.replace(".c", "o.c")

        gccErr = CheckSyntax(filename)
        if ("error:" in gccErr) or ("G[:" in gccErr):
            print ("\n-----syntactic analysis-----\n" + gccErr + "\n-------------------------\n")
            os.remove(filename)
            filename = filename.replace("___.c", ".c")
            print("ERROR: The target can not be analyzed by gcc.\nTarget: [" + filename + "]")
            ReportException("ERROR: GCCō\͂ł܂B\nΏۃt@C: [" + filename + "]")
            shutil.move("temp/error_message", temp_dirname)
            continue

        tempFiles.append(new_filename)
        # gccExec = " ".join([GCC_PATH, "-E", "-P", filename, ">", new_filename])
        gccExec = " ".join([comlines_str, filename, ">", new_filename])
        print(gccExec)
        os.system(gccExec)
        os.remove(filename)

    if (len(tempFiles) == 0):
        print ("All Target Files cannot be analyzed.")
        sys.exit(-1)


    ####################################
    #  (6) START
    ####################################

    for i,filename in enumerate(tempFiles) :
        temp_dirname = temp_dirnames[i]

        if arg.stop_mode == 1:
            continue

        Preprocess(filename)

        if arg.stop_mode == 2:
            continue

        # s ... O͍sPʂ̂߁As܂̋sɂȂꍇłȂ
        RemoveBlankLines()

        if arg.stop_mode == 3:
            continue

        CReform()

        if arg.stop_mode == 4:
            continue

        PreIf()

        if arg.stop_mode == 5:
            continue

        if PreSw()==False: continue

        if arg.stop_mode == 6:
            continue

        Marking()

        if arg.stop_mode == 7:
            continue

        Mujoken()

        if arg.stop_mode == 8:
            continue

        Indent()

        if arg.stop_mode == 9:
            continue

        GlobalDelete()

        if arg.stop_mode == 10:
            continue

        pragma.pragma("temp/temp1", "temp/temp2")

        if arg.stop_mode == 11:
            continue

        tsvFilename = ReplaceFilename(filename)

        if arg.stop_mode == 12:
            continue

        jokenshori.jokenshori("temp/temp2")

        if arg.stop_mode == 13:
            continue

        table.table()

        if arg.stop_mode == 14:
            continue

        jotaivar.jotaivar("temp/temp2")

        if arg.stop_mode == 15:
            continue

        rule_jotaivar.rule_jotaivar("temp/temp2")

        if arg.stop_mode == 16:
            continue

        Postprocess(tsvFilename,temp_dirname)
